local mods, actorCmds

return Def.ActorFrame {
	InitCommand = function(self)
	end,

	OnCommand = function(self)
		local screen = SCREENMAN:GetTopScreen()

		local null = self:GetChild('NullActorFrame')

		local p1 = screen:GetChild('PlayerP1')
		local p2 = screen:GetChild('PlayerP2') or null

		if not p1 then
			for i,v in pairs(screen:GetChild('')) do
				if tostring(v):find('Player') then
					p1 = v
					break
				end
			end
		end

		local players = {p1, p2}

		local p1state = GAMESTATE:GetPlayerState(PLAYER_1)
		local p2state = GAMESTATE:GetPlayerState(PLAYER_2)

		local chordStart = '*10 200% drunk, *10 80% stealth'
		local chordStartReverse = '*10 -200% drunk, *10 80% stealth'
		local chordEnd = '*10 no drunk, *10 no stealth'
		local chordEndHard = '*9999 no drunk, *9999 no stealth'

		local Flivert = '*7 flip,*7 -100% invert'
		local Flivertoff = '*7 no flip,*7 no invert'

		local Fliverthard = '*99 flip,*99 -100% invert'
		local Fliverthardoff = '*99 no flip,*99 no invert'

		local zoomOut = '*7 200% mini'
		local zoomOutRestore = '*99 no mini'

		local shortBreakStart = '*999 30% brake'
		local shortBreakEnd = '*5 no brake'

		local arrowChomp = '*10 50% flip, *10 50% reverse'
		local arrowChompRestore = '*3 no flip, *3 no reverse'

		local hardMini = function(percent)
			return '*999 ' .. percent .. '% mini'
		end

		mods = {
			--Start.
			{0,'*99 dark'},
			{0.1,'*99 2.25x,*1000 no confusion,*99 150% beat,*99 -50% mini,*99 40% flip,no dark,*4 200% hallway'},
			{0.25,'no mini,no flip'},
			{1,'*4 200% distant'},
			{2,'*4 200% hallway'},
			{3,'*4 200% distant'},
			{4,'*4 200% hallway'},
			{5,'*4 200% distant'},
			{6,'*99 overhead'},
			{7,'*4 200% distant'},
			{8,'*4 200% hallway'},
			{9,'*4 200% distant'},
			{10,'*4 200% hallway'},
			{11,'*4 200% distant'},
			{12,'*4 200% hallway'},
			{13,'*4 200% distant'},
			{14,'*4 200% hallway'},
			{15,'*4 200% distant'},
			{15.5,'*10 reverse'},
			{15.75,'*10 no reverse'},
			{16,'*4 200% hallway'},
			{17,'*4 200% distant'},
			{18,'*4 200% hallway'},
			{19,'*4 200% distant'},
			{20,'*4 200% hallway'},
			{21,'*4 200% distant'},
			{22,'*99 overhead'},
			{23,'*4 200% hallway'},
			{24,'*4 200% distant'},
			{25,'*4 200% hallway'},
			{26,'*4 200% distant'},
			{27,'*4 200% hallway'},
			--
			{28,'*5 250% centered,*99 overhead'},
			{28.75,'*99 no centered'},
			{29,'*5 250% centered'},
			{29.75,'*99 no centered'},
			{30,'*5 250% centered'},
			{30.75,'*99 no centered'},
			{31,'*5 250% centered'},
			{31.75,'*99 no centered'},
			{32,'*99 -45% flip'},
			{32.25,'*3 no flip'},
			{33,'*99 -45% flip'},
			{33.25,'*3 no flip'},
			{34,'*99 -45% flip'},
			{34.25,'*3 no flip'},
			{35,'*99 -45% flip'},
			{35.25,'*3 no flip'},
			{36,'*99 -45% flip'},
			{36.25,'*3 no flip'},
			{37,'*99 -45% flip'},
			{37.25,'*3 no flip'},
			{39,'*99 -45% flip'},
			{39.25,'*3 no flip'},
			{40,'*99 -45% flip'},
			{40.25,'*3 no flip'},
			{41,'*99 -45% flip'},
			{41.25,'*3 no flip'},
			{42,'*99 -45% flip'},
			{42.25,'*3 no flip'},
			{43,'*99 -45% flip'},
			{43.25,'*3 no flip'},
			{44,'*99 -45% flip'},
			{44.25,'*3 no flip'},
			{45,'*99 -45% flip'},
			{45.25,'*3 no flip'},
			{46,'*99 -45% flip'},
			{46.25,'*3 no flip'},
			{47,'*99 -45% flip'},
			{47.25,'*3 no flip'},
			--
			{47.5,'*99 reverse,*99 flip'},
			{47.75,'*99 no reverse,*99 no flip'},
			{48,'*99 -45% flip'},
			{48.25,'*3 no flip'},
			{49,'*99 -45% flip'},
			{49.25,'*3 no flip'},
			{50,'*99 -45% flip'},
			{50.25,'*3 no flip'},
			{51,'*99 -45% flip'},
			{51.25,'*3 no flip'},
			{52,'*99 -45% flip'},
			{52.25,'*3 no flip'},
			{53,'*99 -45% flip'},
			{53.25,'*3 no flip'},
			{55,'*99 -45% flip'},
			{55.25,'*3 no flip'},
			{56,'*99 -45% flip'},
			{56.25,'*3 no flip'},
			{57,'*99 -45% flip'},
			{57.25,'*3 no flip'},
			{58,'*99 -45% flip'},
			{58.25,'*3 no flip'},
			{59,'*99 -45% flip'},
			{59.25,'*3 no flip'},
			{60,'*99 -45% flip'},
			{60.25,'*3 no flip'},
			{61,'*99 -45% flip'},
			{61.25,'*3 no flip'},
			{62,'*99 -45% flip'},
			{62.25,'*3 no flip'},
			{63,'*99 -45% flip'},
			{63.25,'*3 no flip'},
			{63.5,'*99 reverse,*99 invert'},
			{63.75,'*99 no reverse,*99 no invert'},
			{64,'*0.3 55% tipsy,*0.3 55% drunk,*99 -45% flip'},
			{64.25,'*3 no flip'},
			{65,'*99 -45% flip'},
			{65.25,'*3 no flip'},
			{66,'*99 -45% flip'},
			{66.25,'*3 no flip'},
			{67,'*99 -45% flip'},
			{67.25,'*3 no flip'},
			{68,'*99 -45% flip'},
			{68.25,'*3 no flip'},
			{69,'*99 -45% flip'},
			{69.25,'*3 no flip'},
			{71,'*99 -45% flip'},
			{71.25,'*3 no flip'},
			{72,'*99 -45% flip'},
			{72.25,'*3 no flip'},
			{73,'*99 -45% flip'},
			{73.25,'*3 no flip'},
			{74,'*99 -45% flip'},
			{74.25,'*3 no flip'},
			{75,'*99 -45% flip'},
			{75.25,'*3 no flip'},
			{76,'*99 -45% flip'},
			{76.25,'*3 no flip'},
			{77,'*99 -45% flip'},
			{77.25,'*3 no flip'},
			{78,'*99 -45% flip'},
			{78.25,'*3 no flip'},
			{79,'*99 -45% flip'},
			{79.25,'*3 no flip'},
			{79.5,'*99 reverse', Fliverthard},
			{79.75,'*99 no reverse', Fliverthardoff},
			{80,'*99 -45% flip'},
			{80.25,'*3 no flip'},
			{81,'*99 -45% flip'},
			{81.25,'*3 no flip'},
			{82,'*99 -45% flip'},
			{82.25,'*3 no flip'},
			{83,'*99 -45% flip'},
			{83.25,'*3 no flip'},
			--
			{84,'*99 -45% flip'},
			{84.25,'*3 no flip'},
			{85,'*99 -45% flip'},
			{85.25,'*3 no flip'},
			{87,'*99 -45% flip'},
			{87.25,'*3 no flip'},
			{88,'*99 -45% flip'},
			{88.25,'*3 no flip'},
			{89,'*99 -45% flip'},
			{89.25,'*3 no flip'},
			{90,'*99 -45% flip'},
			{90.25,'*3 no flip'},
			{91,'*99 -45% flip'},
			{91.25,'*3 no flip'},
			{92,'*99 -45% flip'},
			{92.25,'*3 no flip'},
			{93,'*99 -45% flip'},
			{93.25,'*3 no flip'},
			{94,'*99 -45% flip'},
			{94.25,'*3 no flip'},
			{95,'*99 -45% flip'},
			{95.25,'*3 no flip'},
			{95.5,'*99 reverse,*99 flip'},
			{95.75,'*99 no reverse,*99 no flip'},
			{96,'*9 300% bumpy,*99 -45% flip'},
			{96.25,'*3 no flip'},
			{97,'*99 -45% flip'},
			{97.25,'*3 no flip'},
			{98,'*99 -45% flip'},
			{98.25,'*3 no flip'},
			{99,'*99 -45% flip'},
			{99.25,'*3 no flip'},
			{100,'*99 -45% flip'},
			{100.25,'*3 no flip'},
			{101,'*99 -45% flip'},
			{101.25,'*3 no flip'},
			{103,'*99 -45% flip'},
			{103.25,'*3 no flip'},
			{104,'*99 -45% flip'},
			{104.25,'*3 no flip'},
			{105,'*99 -45% flip'},
			{105.25,'*3 no flip'},
			{106,'*99 -45% flip'},
			{106.25,'*3 no flip'},
			{107,'*99 -45% flip'},
			{107.25,'*3 no flip'},
			{108,'*99 -45% flip'},
			{108.25,'*3 no flip'},
			{109,'*99 -45% flip'},
			{109.25,'*3 no flip'},
			{110,'*99 -45% flip'},
			{110.25,'*3 no flip'},
			{111,'*99 -45% flip'},
			{111.25,'*3 no flip'},
			{111.5,'*99 reverse,*99 invert'},
			{111.75,'*99 no reverse,*99 no invert'},
			{112,'*99 -45% flip'},
			{112.25,'*3 no flip'},
			{113,'*99 -45% flip'},
			{113.25,'*3 no flip'},
			{114,'*99 -45% flip'},
			{114.25,'*3 no flip'},
			{115,'*99 -45% flip'},
			{115.25,'*3 no flip'},
			{116,'*99 -45% flip'},
			{116.25,'*3 no flip'},
			{117,'*99 -45% flip'},
			{117.25,'*3 no flip'},
			{119,'*99 -45% flip'},
			{119.25,'*3 no flip'},
			{120,'*99 -45% flip'},
			{120.25,'*3 no flip'},
			{121,'*99 -45% flip'},
			{121.25,'*3 no flip'},
			{122,'*99 -45% flip'},
			{122.25,'*3 no flip'},
			{123,'*99 -45% flip'},
			{123.25,'*3 no flip'},
			{124,'*99 -45% flip'},
			{124.25,'*3 no flip'},
			{125,'*99 -45% flip'},
			{125.25,'*3 no flip'},
			{126,'*99 -45% flip'},
			{126.25,'*3 no flip'},
			{127,'*99 -45% flip'},
			{127.25,'*3 no flip'},
			--
			{127.5,'*99 reverse', Fliverthard},
			{127.75,'*99 no reverse', Fliverthardoff},
			{128,'*99 no drunk,*99 no tipsy,*0.1 -35% tornado'},
			{135,'*0.3 55% stealth'},
			{143.5,'*99 reverse', Fliverthard},
			{143.75,'*99 no reverse', Fliverthardoff},
			{156,'*2 no tornado,*3 no stealth,*99 no bumpy'},
			{160,'twirl,roll'},
			{163.5,'*7 invert'},
			{163.75,'*7 no invert'},
			{167.5,'*7 flip'},
			{167.75,'*7 no flip'},
			{171.5, Flivert},
			{171.75, Flivertoff},
			{175, zoomOut},
			{176, zoomOutRestore},
			{179.5,'*7 invert'},
			{179.75,'*7 no invert'},
			{183.5,'*7 flip'},
			{183.75,'*7 no flip'},
			{187.5, Flivert},
			{187.75, Flivertoff},
			{189.5,'*5 no twirl,*5 no roll'},
			{192,'-100% twirl,-100% roll'},
			{195.5,'*7 invert'},
			{195.75,'*7 no invert'},
			{196,'*0.1 55% stealth'},
			{199.5,'*7 flip'},
			{199.75,'*7 no flip'},
			{203.5, Flivert},
			{203.75, Flivertoff},
			{207, zoomOut},
			{208, zoomOutRestore},
			{211.5,'*7 flip'},
			{211.75,'*7 no flip'},
			{215.5,'*7 invert'},
			{215.75,'*7 no invert'},
			{219.5, Flivert},
			{219.75, Flivertoff},
			{221.5,'*5 no twirl,*5 no roll,*5 no stealth'},
			{224,'*7 0x'},
			{224.5,'*99 2.25x'},
			{225,'*7 0x'},
			{225.5,'*99 2.25x'},
			{226,'*7 0x'},
			{226.5,'*99 2.25x'},
			{227,'*7 0x'},
			{227.5,'*99 2.25x,*7 invert'},
			{227.75,'*7 no invert'},
			{228,'*7 0x'},
			{228.5,'*99 2.25x'},
			{229,'*7 0x'},
			{229.5,'*99 2.25x'},
			{230,'*7 0x'},
			{230.5,'*99 2.25x'},
			{231,'*7 0x'},
			{231.5,'*99 2.25x,*7 flip'},
			{231.75,'*7 no flip'},
			{232,'*7 0x'},
			{232.5,'*99 2.25x'},
			{233,'*7 0x'},
			{233.5,'*99 2.25x'},
			{234,'*7 0x'},
			{234.5,'*99 2.25x'},
			{235,'*7 0x'},
			{235.5,'*99 2.25x', Flivert},
			{235.75, Flivertoff},
			{236,'*7 0x'},
			{236.5,'*99 2.25x'},
			{237,'*7 0x'},
			{237.5,'*99 2.25x'},
			{238,'*7 0x'},
			{238.5,'*99 2.25x'},
			{239,'*14 8x'},
			{239.5,'*99 2.25x'},
			{240,'*7 0x'},
			{240.5,'*99 2.25x'},
			{241,'*7 0x'},
			{241.5,'*99 2.25x'},
			{242,'*7 0x'},
			{242.5,'*99 2.25x'},
			{243,'*7 0x'},
			{243.5,'*99 2.25x,*7 flip'},
			{243.75,'*7 no flip'},
			--
			{244,'*7 0x'},
			{244.5,'*99 2.25x'},
			{245,'*7 0x'},
			{245.5,'*99 2.25x'},
			{246,'*7 0x'},
			{246.5,'*99 2.25x'},
			{247,'*7 0x'},
			{247.5,'*99 2.25x,*7 invert'},
			{247.75,'*7 no invert'},
			{248,'*7 0x'},
			{248.5,'*99 2.25x'},
			{249,'*7 0x'},
			{249.5,'*99 2.25x'},
			{250,'*7 0x'},
			{250.5,'*99 2.25x'},
			{251,'*7 0x'},
			{251.5,'*99 2.25x', Flivert},
			{251.75, Flivertoff},
			{252,'*7 0x'},
			{252.5,'*99 2.25x'},
			{253.5,'*9 25% flip'},
			{256,'*7 0x,*99 no flip'},
			{256.5,'*99 2.25x'},
			{257,'*7 0x'},
			{257.5,'*99 2.25x'},
			{258,'*7 0x'},
			{258.5,'*99 2.25x'},
			{259,'*7 0x'},
			{259.5,'*99 2.25x,*7 invert'},
			{259.75,'*7 no invert'},
			{260,'*7 0x'},
			{260.5,'*99 2.25x'},
			{261,'*7 0x'},
			{261.5,'*99 2.25x'},
			{262,'*7 0x'},
			{262.5,'*99 2.25x'},
			{263,'*7 0x'},
			{263.5,'*99 2.25x,*7 flip'},
			{263.75,'*7 no flip'},
			{264,'*7 0x'},
			{264.5,'*99 2.25x'},
			{265,'*7 0x'},
			{265.5,'*99 2.25x'},
			{266,'*7 0x'},
			{266.5,'*99 2.25x'},
			{267,'*7 0x'},
			{267.5,'*99 2.25x', Flivert},
			{267.75, Flivertoff},
			{268,'*7 0x'},
			{268.5,'*99 2.25x'},
			{269,'*7 0x'},
			{269.5,'*99 2.25x'},
			{270,'*7 0x'},
			{270.5,'*99 2.25x'},
			{271,'*14 8x'},
			{271.5,'*99 2.25x'},
			{272,'*7 0x'},
			{272.5,'*99 2.25x'},
			{273,'*7 0x'},
			{273.5,'*99 2.25x'},
			{274,'*7 0x'},
			{274.5,'*99 2.25x'},
			{275,'*7 0x'},
			{275.5,'*99 2.25x,*7 flip'},
			{275.75,'*7 no flip'},
			{276,'*7 0x'},
			{276.5,'*99 2.25x'},
			{277,'*7 0x'},
			{277.5,'*99 2.25x'},
			{278,'*7 0x'},
			{278.5,'*99 2.25x'},
			{279,'*7 0x'},
			{279.5,'*99 2.25x'},
			{280,'*10000 -120000% bumpy,*10000 0.0015x,*10000 overhead,*10000 80% centered,*10000 120% distant'},
			{288,'*99 2.25x,*1000 no confusion,*10000 no bumpy,*99 no centered,*99 no distant'},
			{303.5,'*99 reverse,*99 invert'},
			{303.75,'*99 no reverse,*99 no invert'},
			{319.5,'*99 reverse,*99 flip'},
			{319.75,'*99 no reverse,*99 no flip'},
			{320,'*0.1 55% stealth,*0.3 -25% tornado,*0.2 -45% mini,*0.05 35% flip,*0.2 155% bumpy'},
			{335.5,'*99 reverse', Fliverthard},
			{335.75,'*99 no reverse,*99 no invert,*99 35% flip'},
			{348,'*3 no stealth,*3 no bumpy,*3 no tornado,*3 no mini,*3 no flip'},
			{352,'*7 0x,*99 2000% confusion'},
			{352.5,'*99 2.25x,*1000 no confusion'},
			{353,'*7 0x,*99 2000% confusion'},
			{353.5,'*99 2.25x,*1000 no confusion'},
			{354,'*7 0x,*99 2000% confusion'},
			{354.5,'*99 2.25x,*1000 no confusion'},
			{355,'*7 0x,*99 2000% confusion'},
			{355.5,'*99 2.25x,*1000 no confusion,*7 invert'},
			{355.75,'*7 no invert'},
			{356,'*7 0x,*99 2000% confusion'},
			{356.5,'*99 2.25x,*1000 no confusion'},
			{357,'*7 0x,*99 2000% confusion'},
			{357.5,'*99 2.25x,*1000 no confusion'},
			{358,'*7 0x,*99 2000% confusion'},
			{358.5,'*99 2.25x,*1000 no confusion'},
			{359,'*7 0x,*99 2000% confusion'},
			{359.5,'*99 2.25x,*1000 no confusion,*7 flip'},
			{359.75,'*7 no flip'},
			--360 NOSCOPED!
			{360,'*7 0x,*99 2000% confusion'},
			{360.5,'*99 2.25x,*1000 no confusion'},
			{361,'*7 0x,*99 2000% confusion'},
			{361.5,'*99 2.25x,*1000 no confusion'},
			{362,'*7 0x,*99 2000% confusion'},
			{362.5,'*99 2.25x,*1000 no confusion'},
			{363,'*7 0x,*99 2000% confusion'},
			{363.5,'*99 2.25x,*1000 no confusion', Flivert},
			{363.75, Flivertoff},
			{364,'*7 0x,*99 2000% confusion'},
			{364.5,'*99 2.25x,*1000 no confusion'},
			{365,'*7 0x,*99 2000% confusion'},
			{365.5,'*99 2.25x,*1000 no confusion'},
			{366,'*7 0x,*99 2000% confusion'},
			{366.5,'*99 2.25x,*1000 no confusion'},
			{367,'*14 8x'},
			{367.5,'*99 2.25x,*1000 no confusion'},
			{368,'*7 0x,*99 2000% confusion'},
			{368.5,'*99 2.25x,*1000 no confusion'},
			{369,'*7 0x,*99 2000% confusion'},
			{369.5,'*99 2.25x,*1000 no confusion'},
			{370,'*7 0x,*99 2000% confusion'},
			{370.5,'*99 2.25x,*1000 no confusion'},
			{371,'*7 0x,*99 2000% confusion'},
			{371.5,'*99 2.25x,*1000 no confusion,*7 flip'},
			{371.75,'*7 no flip'},
			{372,'*7 0x,*99 2000% confusion'},
			{372.5,'*99 2.25x,*1000 no confusion'},
			{373,'*7 0x,*99 2000% confusion'},
			{373.5,'*99 2.25x,*1000 no confusion'},
			{374,'*7 0x,*99 2000% confusion'},
			{374.5,'*99 2.25x,*1000 no confusion'},
			{375,'*7 0x,*99 2000% confusion'},
			{375.5,'*99 2.25x,*1000 no confusion,*7 invert'},
			{375.75,'*7 no invert'},
			{376,'*7 0x,*99 2000% confusion'},
			{376.5,'*99 2.25x,*1000 no confusion'},
			{377,'*7 0x,*99 2000% confusion'},
			{377.5,'*99 2.25x,*1000 no confusion'},
			{378,'*7 0x,*99 2000% confusion'},
			{378.5,'*99 2.25x,*1000 no confusion'},
			{379,'*7 0x,*99 2000% confusion'},
			{379.5,'*99 2.25x,*1000 no confusion', Flivert},
			{379.75, Flivertoff},
			{380,'*7 0x,*99 2000% confusion'},
			{380.5,'*99 2.25x,*1000 no confusion'},
			{381.5,'*9 -25% flip'},
			{382,'*7 0x,*99 2000% confusion,*99 no flip'},
			{382.5,'*99 2.25x,*1000 no confusion'},
			{383,'*7 0x,*99 2000% confusion'},
			{383.5,'*99 2.25x,*1000 no confusion'},
			{384,'*7 0x,*99 2000% confusion'},
			{384.5,'*99 2.25x,*1000 no confusion'},
			{385,'*7 0x,*99 2000% confusion'},
			{385.5,'*99 2.25x,*1000 no confusion'},
			{386,'*7 0x,*99 2000% confusion'},
			{386.5,'*99 2.25x,*1000 no confusion'},
			{387,'*7 0x,*99 2000% confusion'},
			{387.5,'*99 2.25x,*1000 no confusion,*7 invert'},
			{387.75,'*7 no invert'},
			--
			{388,'*7 0x,*99 2000% confusion'},
			{388.5,'*99 2.25x,*1000 no confusion'},
			{389,'*7 0x,*99 2000% confusion'},
			{389.5,'*99 2.25x,*1000 no confusion'},
			{390,'*7 0x,*99 2000% confusion'},
			{390.5,'*99 2.25x,*1000 no confusion'},
			{391,'*7 0x,*99 2000% confusion'},
			{391.5,'*99 2.25x,*1000 no confusion,*7 flip'},
			{391.75,'*7 no flip'},
			{392,'*7 0x,*99 2000% confusion'},
			{392.5,'*99 2.25x,*1000 no confusion'},
			{393,'*7 0x,*99 2000% confusion'},
			{393.5,'*99 2.25x,*1000 no confusion'},
			{394,'*7 0x,*99 2000% confusion'},
			{394.5,'*99 2.25x,*1000 no confusion'},
			{395,'*7 0x,*99 2000% confusion'},
			{395.5,'*99 2.25x,*1000 no confusion', Flivert},
			{395.75, Flivertoff},
			{396,'*7 0x,*99 2000% confusion'},
			{396.5,'*99 2.25x,*1000 no confusion'},
			{397,'*7 0x,*99 2000% confusion'},
			{397.5,'*99 2.25x,*1000 no confusion'},
			{398,'*7 0x,*99 2000% confusion'},
			{398.5,'*99 2.25x,*1000 no confusion'},
			{399,'*14 8x,*99 2000% confusion'},
			{399.5,'*99 2.25x,*1000 no confusion'},
			{400,'*7 0x,*99 2000% confusion'},
			{400.5,'*99 2.25x,*1000 no confusion'},
			{401,'*7 0x,*99 2000% confusion'},
			{401.5,'*99 2.25x,*1000 no confusion'},
			{402,'*7 0x,*99 2000% confusion'},
			{402.5,'*99 2.25x,*1000 no confusion'},
			{403,'*7 0x,*99 2000% confusion'},
			{403.5,'*99 2.25x,*1000 no confusion,*7 flip'},
			{403.75,'*7 no flip'},
			{404,'*7 0x,*99 2000% confusion'},
			{404.5,'*99 2.25x,*1000 no confusion'},
			{405,'*7 0x,*99 2000% confusion'},
			{405.5,'*99 2.25x,*1000 no confusion'},
			{406,'*7 0x,*99 2000% confusion'},
			{406.5,'*99 2.25x,*1000 no confusion'},
			{407,'*7 0x,*99 2000% confusion'},
			{407.5,'*99 2.25x,*1000 no confusion,*7 invert'},
			{407.75,'*7 no invert'},
			{408,'*7 0x,*99 2000% confusion'},
			{408.5,'*99 2.25x,*1000 no confusion'},
			{409,'*7 0x,*99 2000% confusion'},
			{409.5,'*99 2.25x,*1000 no confusion'},
			{410,'*7 0x,*99 2000% confusion'},
			{410.5,'*99 2.25x,*1000 no confusion'},
			{411,'*7 0x,*99 2000% confusion'},
			{411.5,'*99 2.25x,*1000 no confusion', Flivert},
			{411.75, Flivertoff},
			{412,'*7 0x,*99 2000% confusion'},
			{412.5,'*99 2.25x,*1000 no confusion'},
			--
			{416,'dizzy'},
			{419.5,'*7 flip'},
			{419.75,'*7 no flip'},
			{423.5,'*7 invert'},
			{423.75,'*7 no invert'},
			{427.5, Flivert},
			{427.75, Flivertoff},
			{431, zoomOut},
			{432, zoomOutRestore},
			{435.5,'*7 invert'},
			{435.75,'*7 no invert'},
			{439.5,'*7 flip'},
			{439.75,'*7 no flip'},
			{443.5, Flivert},
			{443.75, Flivertoff},
			{445.5,'*99 no dizzy'},
			{448,'-100% dizzy'},
			{451.5, Flivert},
			{451.75, Flivertoff},
			{455.5,'*7 flip'},
			{455.75,'*7 no flip'},
			{459.5,'*7 invert'},
			{459.75,'*7 no invert'},
			{463, zoomOut},
			{464, zoomOutRestore},
			{467.5,'*7 invert'},
			{467.75,'*7 no invert'},
			{471.5,'*7 flip'},
			{471.75,'*7 no flip'},
			{475.5, Flivert},
			{475.75, Flivertoff},
			{477.5,'*99 no dizzy'},
			{480,'*30 40% brake'},
			{481,'-40% brake'},
			{482,'*30 40% brake'},
			{483,'-40% brake'},
			{484,'*30 40% brake'},
			{485,'-40% brake'},
			{488,'*30 40% brake'},
			{489,'*30 40% brake'},
			{490,'-40% brake'},
			{491,'*30 40% brake'},
			{492,'-40% brake'},
			{493,'*30 40% brake'},
			{494,'-40% brake'},
			{495,'*30 40% brake'},
			{495.5,'*99 reverse,*99 invert'},
			{495.75,'*99 no reverse,*99 no invert'},
			{496,'*30 40% brake'},
			{497,'-40% brake'},
			{498,'*30 40% brake'},
			{499,'-40% brake'},
			{500,'*30 40% brake'},
			{503,'-40% brake'},
			{504,'*30 40% brake'},
			{505,'-40% brake'},
			{506,'*30 40% brake'},
			{507,'-40% brake'},
			{508,'*30 40% brake'},
			{509,'-40% brake'},
			{510,'*30 40% brake'},
			{511,'*99 no brake'},
			{511.5,'*99 reverse', Fliverthard},
			{511.75,'*99 no reverse', Fliverthardoff},
			{527.5,'*99 reverse,*99 flip'},
			{527.75,'*99 no reverse,*99 no flip'},
			{532,'*0.1 95% stealth'},
			{544,'*5 dark', zoomOut}
			--End.
		}


		local introWag = function()
			p1:wag():effectmagnitude(0, 0, 15):effectclock('beat'):effectperiod(16)
			p2:wag():effectmagnitude(0, 0, 15):effectclock('beat'):effectperiod(16)
		end

		local stopEffect = function()
			p1:stopeffect()
			p2:stopeffect()
		end

		local spin = function()
			for i=1, #players do
				players[i]
					:decelerate(0.10)
					:smooth(1)
					:addrotationz(360)
			end
		end
		
		local Endin = function()
			for i=1, #players do
				players[i]
					:decelerate(0.10)
					:smooth(1.5)
					:addrotationz(9999)
			end
		end
		
		local spinReverse = function()
			for i=1, #players do
				players[i]
					:decelerate(0.10)
					:smooth(1)
					:addrotationz(-360)
			end
		end

		local playfieldWiggle = function()
			for i=1, #players do
				players[i]
					:linear(0.07)
					:skewx(-0.3)
					:linear(0.07)
					:skewx(0.3)
					:linear(0.07)
					:skewx(-0.3)
					:linear(0.07)
					:skewx(0.3)
					:accelerate(0.1)
					:skewx(0)
			end
		end

		local bassPivot = function()
			local dist = 60
			for i=1, #players do
				players[i]
					:linear(60/130 * .25)
					:addx(-dist)
					:addrotationy(-30)

					:linear(60/130 * .25)
					:addx(dist*2)
					:addrotationy(60)

					:linear(60/130 * .50)
					:addx(-dist*2)
					:addrotationy(-60)

					:linear(60/130 * .50)
					:addx(dist)
					:addrotationy(30)
			end
		end

		local switch = function()
			if GAMESTATE:GetNumPlayersEnabled() > 1 then
				local x1,x2 = p1:GetX(), p2:GetX()
				p1:x(x2)
				p2:x(x1)
			end
		end

		local rotationSwitch = function()
			for i=1, #players do
				local player = players[i]
				local xbase = player:GetX()

				player
					:decelerate(60/130)
					:x(SCREEN_CENTER_X + (SCREEN_CENTER_X - xbase))
					:addrotationy(360)

					:decelerate(60/130)
					:x(xbase)
					:addrotationy(-360)
			end
		end

		actorCmds = {
			--Lua cmds start.
			{5.5, spin},
			{21.5, spinReverse},
			{37.5, spin},
			{53.5, spinReverse},
			{69.5, spin},
			{85.5, spinReverse},
			{101.5, spin},
			{117.5, spinReverse},
			{133.5, spin},
			{149.5, spinReverse},
			{189.5, spin},
			{221.5, spinReverse},
			{253.5, spin},
			{285.5, spinReverse},
			{293.5, spin},
			{309.5, spinReverse},
			{325.5, spin},
			{341.5, spinReverse},
			{381.5, spin},
			{413.5, spinReverse},
			{445.5, spin},
			{477.5, spinReverse},
			{485.5, spin},
			{501.5, spinReverse},
			{517.5, spin},
			{533.5, spinReverse},
			{544, Endin}
			--Lua cmds end.
		}

		-- for edit mode
		-- for i=#mods, 1, -1 do
		-- 	if GAMESTATE:GetSongBeat() > mods[i][1] then
		-- 		table.remove(mods, i)
		-- 	end
		-- end

		for i=#actorCmds, 1, -1 do
			if GAMESTATE:GetSongBeat() > actorCmds[i][1] then
				table.remove(actorCmds, i)
			end
		end

		p1:stopeffect()
		p2:stopeffect()

		local firstRun = true
		self:SetUpdateFunction(function(self, delta)
			local currentBeat = GAMESTATE:GetSongBeat()

			for i=1, #mods do
				local mod = mods[i]
				if not mod.done and currentBeat >= mod[1] then
					local modstr = table.concat({ unpack(mod, 2) }, ',')
					p1state:SetPlayerOptions('ModsLevel_Song', p1state:GetPlayerOptionsString('ModsLevel_Song')..','..modstr)
					p2state:SetPlayerOptions('ModsLevel_Song', p2state:GetPlayerOptionsString('ModsLevel_Song')..','..modstr)
					mod.done = true

					-- this is horrible, like, no
					-- only keeping for historical purposes
					-- for modname, values in pairs(mod) do
					-- 	if p1options[modname] then
					-- 		p1options[modname](p1options, unpack(values))
					-- 		p2options[modname](p2options, unpack(values))
					-- 	end
					-- end

					if not firstRun then
						break
					end
				end
			end

			for i=1, #actorCmds do
				local command = actorCmds[i]
				if not command.done and currentBeat > command[1] then
					command[2]()
					command.done = true
				end
			end

			if firstRun then
				p1:finishtweening()
				p2:finishtweening()
			end
			firstRun = false
		end)
	end,

	Def.Quad{ OnCommand = function(self) self:sleep(1000) end },
	Def.ActorFrame{ Name='NullActorFrame' },
}
